// BaseParaSet.cpp : implementation file
//

#include "stdafx.h"
#include "DEMO.h"
#include "BaseParaSet.h"
#include "CtrlCard.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CCtrlCard g_CtrlCard;
/////////////////////////////////////////////////////////////////////////////
// CBaseParaSet dialog

int effectlogic_x ;
int effectlogic_y ;
int effectlogic_z ;
int effectlogic_a ;
int registermode=0;


CBaseParaSet::CBaseParaSet(CWnd* pParent /*=NULL*/)
	: CDialog(CBaseParaSet::IDD, pParent)
{
	//{{AFX_DATA_INIT(CBaseParaSet)
	m_nEffectLogic_x = -1;
	m_nEffectLogic_y = -1;
	m_nEffectLogic_z = -1;
	m_nNLimitMode_x = -1;
	m_nNLimitMode_y = -1;
	m_nNLimitMode_z = -1;
	m_nPLimitMode_x = -1;
	m_nPLimitMode_y = -1;
	m_nPLimitMode_z = -1;
	m_nPulseMode_x = -1;
	m_nPulseMode_y = -1;
	m_nPulseMode_z = -1;
	m_nStop0Mode_x = -1;
	m_nStop0Mode_y = -1;
	m_nStop0Mode_z = -1;
	m_nStop1Mode_x = -1;
	m_nStop1Mode_y = -1;
	m_nStop1Mode_z = -1;
	m_nHardLogic = -1;
	m_nHardStop = -1;
	m_nStop1Mode_a = -1;
	m_nStop0Mode_a = -1;
	m_nPLimitMode_a = -1;
	m_nNLimitMode_a = -1;
	m_nEffectLogic_a = -1;
	m_nPulseMode_a = -1;
	m_nRegiMode = 0;
	//}}AFX_DATA_INIT
}


void CBaseParaSet::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CBaseParaSet)
	DDX_Radio(pDX, IDC_EFFECTLOGIC_X, m_nEffectLogic_x);
	DDX_Radio(pDX, IDC_EFFECTLOGIC_Y, m_nEffectLogic_y);
	DDX_Radio(pDX, IDC_EFFECTLOGIC_Z, m_nEffectLogic_z);
	DDX_Radio(pDX, IDC_NLIMITMODE_X, m_nNLimitMode_x);
	DDX_Radio(pDX, IDC_NLIMITMODE_Y, m_nNLimitMode_y);
	DDX_Radio(pDX, IDC_NLIMITMODE_Z, m_nNLimitMode_z);
	DDX_Radio(pDX, IDC_PLIMITMODE_X, m_nPLimitMode_x);
	DDX_Radio(pDX, IDC_PLIMITMODE_Y, m_nPLimitMode_y);
	DDX_Radio(pDX, IDC_PLIMITMODE_Z, m_nPLimitMode_z);
	DDX_Radio(pDX, IDC_PULSEMODE_X, m_nPulseMode_x);
	DDX_Radio(pDX, IDC_PULSEMODE_Y, m_nPulseMode_y);
	DDX_Radio(pDX, IDC_PULSEMODE_Z, m_nPulseMode_z);
	DDX_Radio(pDX, IDC_STOP0MODE_X, m_nStop0Mode_x);
	DDX_Radio(pDX, IDC_STOP0MODE_Y, m_nStop0Mode_y);
	DDX_Radio(pDX, IDC_STOP0MODE_Z, m_nStop0Mode_z);
	DDX_Radio(pDX, IDC_STOP1MODE_X, m_nStop1Mode_x);
	DDX_Radio(pDX, IDC_STOP1MODE_Y, m_nStop1Mode_y);
	DDX_Radio(pDX, IDC_STOP1MODE_Z, m_nStop1Mode_z);
	DDX_Radio(pDX, IDC_HARDLOGIC, m_nHardLogic);
	DDX_Radio(pDX, IDC_HARDSTOP, m_nHardStop);
	DDX_Radio(pDX, IDC_STOP1MODE_A, m_nStop1Mode_a);
	DDX_Radio(pDX, IDC_STOP0MODE_A, m_nStop0Mode_a);
	DDX_Radio(pDX, IDC_PLIMITMODE_A, m_nPLimitMode_a);
	DDX_Radio(pDX, IDC_NLIMITMODE_A, m_nNLimitMode_a);
	DDX_Radio(pDX, IDC_EFFECTLOGIC_A, m_nEffectLogic_a);
	DDX_Radio(pDX, IDC_PULSEMODE_A, m_nPulseMode_a);
	DDX_Radio(pDX, IDC_REGISTER_MODE0, m_nRegiMode);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CBaseParaSet, CDialog)
	//{{AFX_MSG_MAP(CBaseParaSet)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBaseParaSet message handlers

BOOL CBaseParaSet::OnInitDialog() 
{
	CDialog::OnInitDialog();
	//************set base para********************//
	//******************set pulse type*************//
	//    0-pulse + pulse   1pulse + direction   //
	//        default :  pulse + direction         //
	//*********************************************//
    m_nPulseMode_x  = 1;
	m_nPulseMode_y  = 1;
	m_nPulseMode_z  = 1;
	m_nPulseMode_a  = 1;
	//**********Set LMT+ type************//
	//    0-effective   1ineffective   //
	//        default :  effective       //
	//***********************************//
	m_nPLimitMode_x = 0;
	m_nPLimitMode_y = 0;
	m_nPLimitMode_z = 0;
	m_nPLimitMode_a = 0;
	//**********Set LMT- type************//
	//    0-effective   1ineffective   //
	//        default :  effective       //
	//***********************************//
	m_nNLimitMode_x = 0;
	m_nNLimitMode_y = 0;
	m_nNLimitMode_z = 0;
	m_nNLimitMode_a = 0;
	//**********Set stop0 type************//
	//    0-ineffective   1effective   //
	//        default :  infective       //
	//***********************************//
	m_nStop0Mode_x  = 0;
	m_nStop0Mode_y  = 0;
	m_nStop0Mode_z  = 0;
	m_nStop0Mode_a  = 0;
	//**********Set stop1 type************//
	//    0-ineffective   1effective   //
	//        default :  infective       //
	//***********************************//
	m_nStop1Mode_x  = 0;
	m_nStop1Mode_y  = 0;
	m_nStop1Mode_z  = 0;
	m_nStop1Mode_a  = 0;
	//***********set level ************//
	//for level of LMT+/-STOP0STOP1//
	//   0-low level effective   1high level effective    //
	//        default:    low level effective    //
	//***********************************//
	m_nEffectLogic_x = 0;
	m_nEffectLogic_y = 0;
	m_nEffectLogic_z = 0;
	m_nEffectLogic_a = 0;
	//******************set hard-stop**************//
	//     for stop in hardware                    //
	// m_nHardStop 0-ineffective   1-effective     //
	// m_nHardLogic 0-low level    1-high level    //
	//      default : ineffective                 //
	//********************************************//
	m_nHardStop      = 0;
	m_nHardLogic     = 0;

	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CBaseParaSet::OnOK() 
{
	UpdateData();

	effectlogic_x=m_nEffectLogic_x;
	
	effectlogic_y=m_nEffectLogic_y;
	
	effectlogic_z=m_nEffectLogic_z;
	
	effectlogic_a=m_nEffectLogic_a;
	
	registermode=m_nRegiMode;

	int  pulsemode[]={m_nPulseMode_x, m_nPulseMode_y, m_nPulseMode_z, m_nPulseMode_a};    //ʽ      

	int  plimitmode[]={m_nPLimitMode_x, m_nPLimitMode_y, m_nPLimitMode_z, m_nPLimitMode_a};   //λģʽ 

	int  nlimitmode[]={m_nNLimitMode_x, m_nNLimitMode_y, m_nNLimitMode_z, m_nNLimitMode_a};   //λģʽ
	
	int  stop0mode[]={m_nStop0Mode_x, m_nStop0Mode_y, m_nStop0Mode_z,m_nStop0Mode_a};         //stop0ģʽ

	int  stop1mode[]={m_nStop1Mode_x, m_nStop1Mode_y, m_nStop1Mode_z,m_nStop1Mode_a};         //stop1ģʽ

	int  effectlogic[]={m_nEffectLogic_x, m_nEffectLogic_y, m_nEffectLogic_z, m_nEffectLogic_a};  //ƽ

	for(int i=1; i<MAXAXIS+1; i++)
	{
		//set pulse type
		g_CtrlCard.Setup_PulseMode(i, pulsemode[i-1]);             

		//set limit type
		g_CtrlCard.Setup_LimitMode(i, plimitmode[i-1], nlimitmode[i-1], effectlogic[i-1]);

		//set stop0 type
		g_CtrlCard.Setup_Stop0Mode(i, stop0mode[i-1], effectlogic[i-1]);

		//set stop1 type
		g_CtrlCard.Setup_Stop1Mode(i, stop1mode[i-1], effectlogic[i-1]);
	}

	//set hard-stop type
	g_CtrlCard.Setup_HardStop(m_nHardStop, m_nHardLogic);

	CDialog::OnOK();
}
